/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3;

public record DamageSourceCondition(Optional<DamageSourcePredicate> predicate) implements LootItemCondition
{
    public static final MapCodec<DamageSourceCondition> CODEC = RecordCodecBuilder.mapCodec(p_338167_ -> p_338167_.group((App)DamageSourcePredicate.CODEC.optionalFieldOf("predicate").forGetter(DamageSourceCondition::predicate)).apply((Applicative)p_338167_, DamageSourceCondition::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.DAMAGE_SOURCE_PROPERTIES;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParams.ORIGIN, LootContextParams.DAMAGE_SOURCE);
    }

    @Override
    public boolean test(LootContext p_81592_) {
        DamageSource $$1 = p_81592_.getParamOrNull(LootContextParams.DAMAGE_SOURCE);
        Vec3 $$2 = p_81592_.getParamOrNull(LootContextParams.ORIGIN);
        if ($$2 == null || $$1 == null) {
            return false;
        }
        return this.predicate.isEmpty() || this.predicate.get().matches(p_81592_.getLevel(), $$2, $$1);
    }

    public static LootItemCondition.Builder hasDamageSource(DamageSourcePredicate.Builder p_81590_) {
        return () -> new DamageSourceCondition(Optional.of(p_81590_.build()));
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootContext)object);
    }
}

